<?php
/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'options_framework_theme'
 * with the actual text domain for your theme.  Read more:
 * http://codex.WordPress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Test data
	$test_array = array(
		'one' => 'One',
		'two' => 'Two',
		'three' => 'Three',
		'four' => 'Four',
		'five' => 'Five'
	);

	// Multicheck Array
	$multicheck_array = array(
		'one' => 'French Toast',
		'two' => 'Pancake',
		'three' => 'Omelette',
		'four' => 'Crepe',
		'five' => 'Waffle'
	);

	// Multicheck Defaults
	$multicheck_defaults = array(
		'one' => '1',
		'five' => '1'
	);

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Typography Defaults
	$typography_defaults = array(
		'size' => '15px',
		'face' => 'georgia',
		'style' => 'bold',
		'color' => '#bada55' );

	// Typography Options
	$typography_options = array(
		'sizes' => array( '6','12','14','16','20' ),
		'faces' => array( 'Helvetica Neue' => 'Helvetica Neue','Arial' => 'Arial' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);
	
	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
		
	// Pull all the posts into an array
	$options_posts = array();
	$options_posts_obj = get_posts('sort_column=menu_order&sort_order=asc&posts_per_page=-1');
	foreach ($options_posts_obj as $post) {
		$options_posts[$post->ID] = $post->post_title;
	}
	
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}

	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}
	
	// Pull all the sidebars into an array
	$sidebars = get_option('sidebars');
	$new_sidebars = array('default'=> 'Default');
	foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar) {
		$new_sidebars[$sidebar['id']] = $sidebar['name'];
	}
	
	$export = array(vpanel_options,"sidebars");
	$current_options = array();
	foreach ($export as $options) {
		if (get_option($options)) {
			$current_options[$options] = get_option($options);
		}else {
			$current_options[$options] = array();
		}
	}
	$current_options_e = base64_encode(serialize($current_options));
	
	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/admin/images/';

	$options = array();
	
	$options[] = array(
		'name' => 'General settings',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Enable loader',
		'desc' => 'Select on to enable loader .',
		'id' => 'loader',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Enable stripe',
		'desc' => 'Select on to enable stripe .',
		'id' => 'stripe',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Enable nicescroll',
		'desc' => 'Select on to enable nicescroll .',
		'id' => 'nicescroll',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Enable SEO options',
		'desc' => 'Select on to enable SEO options .',
		'id' => 'seo_active',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "Header code",
		'desc' => "Past your Google analytics code in the box",
		'id' => 'head_code',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'name' => "Footer code",
		'desc' => "Paste footer code in the box",
		'id' => 'footer_code',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'name' => "Custom CSS code",
		'desc' => "Advanced CSS options , Paste your CSS code in the box",
		'id' => 'custom_css',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => "SEO keywords",
		'desc' => "Paste your keywords in the box",
		'id' => 'the_keywords',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => "WordPress login logo",
		'desc' => "This is the logo that appears on the default WordPress login page",
		'id' => 'login_logo',
		'type' => 'upload');
	
	$options[] = array(
		'name' => "Custom favicon",
		'desc' => "Upload the site’s favicon here , You can create new favicon here favicon.cc",
		'id' => 'favicon',
		'type' => 'upload');
	
	$options[] = array(
		'name' => "Custom favicon for iPhone",
		'desc' => "Upload your custom iPhone favicon",
		'id' => 'iphone_icon',
		'type' => 'upload');
	
	$options[] = array(
		'name' => "Custom iPhone retina favicon",
		'desc' => "Upload your custom iPhone retina favicon",
		'id' => 'iphone_icon_retina',
		'type' => 'upload');
	
	$options[] = array(
		'name' => "Custom favicon for iPad",
		'desc' => "Upload your custom iPad favicon",
		'id' => 'ipad_icon',
		'type' => 'upload');
	
	$options[] = array(
		'name' => "Custom iPad retina favicon",
		'desc' => "Upload your custom iPad retina favicon",
		'id' => 'ipad_icon_retina',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Header settings',
		'type' => 'heading');
	
	$options[] = array(
		'name' => "Header style",
		'desc' => "Select the header style .",
		'id' => "header_style",
		'std' => "1",
		'type' => "select",
		'options' => array(
			'1' => 'Header 1',
			'2' => 'Header 2',
			'3' => 'Header 3',
			'4' => 'Header 4',
			'5' => 'Header 5',
		)
	);
	
	$options[] = array(
		'name' => 'Logo display',
		'desc' => 'choose Logo display .',
		'id' => 'logo_display',
		'std' => 'display_title',
		'type' => 'radio',
		'options' => array("display_title" => "Display site title","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Logo upload',
		'desc' => 'Upload your custom logo. ',
		'id' => 'logo_img',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Header menu settings',
		'desc' => 'Select on to enable the menu in the header .',
		'id' => 'header_menu',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Header menu style',
		'desc' => 'Choose the header menu style .',
		'id' => 'header_menu_style',
		'std' => '1',
		'options' => array("1" => "Style 1","2" => "Style 2"),
		'type' => 'radio');
	
	$options[] = array(
		'name' => 'Fixed header option',
		'desc' => 'Select on to enable fixed header .',
		'id' => 'header_fixed',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Stop fixed header in mobile option',
		'desc' => 'Select on to stop fixed header in mobile .',
		'id' => 'header_fixed_responsive',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Advertising type',
		'desc' => 'Advertising type .',
		'id' => 'header_adv_type_3',
		'std' => 'custom_image',
		'type' => 'radio',
		'options' => array("display_code" => "Display code","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Image URL',
		'desc' => 'Upload a image, or enter URL to an image if it is already uploaded. ',
		'id' => 'header_adv_img_3',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Advertising url',
		'desc' => 'Advertising url. ',
		'id' => 'header_adv_href_3',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advertising Code html ( Ex: Google ads)",
		'desc' => "Advertising Code html ( Ex: Google ads)",
		'id' => 'header_adv_code_3',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => 'Header cart settings',
		'desc' => 'Select on to enable the cart in the header .',
		'id' => 'header_cart',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Header search settings',
		'desc' => 'Select on to enable the search in the header .',
		'id' => 'header_search',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Header follow settings',
		'desc' => 'Select on to enable the follow me in the header .',
		'id' => 'header_follow',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Header follow style',
		'desc' => 'Choose the header follow style .',
		'id' => 'header_follow_style',
		'std' => '1',
		'options' => array("1" => "Style 1","2" => "Style 2"),
		'type' => 'radio');
	
	$options[] = array(
		'name' => 'Facebook URL',
		'desc' => 'Type the facebook URL from here .',
		'id' => 'facebook_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter URL',
		'desc' => 'Type the twitter URL from here .',
		'id' => 'twitter_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Google plus URL',
		'desc' => 'Type the google plus URL from here .',
		'id' => 'gplus_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Linkedin URL',
		'desc' => 'Type the linkedin URL from here .',
		'id' => 'linkedin_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Dribbble URL',
		'desc' => 'Type the dribbble URL from here .',
		'id' => 'dribbble_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Youtube URL',
		'desc' => 'Type the youtube URL from here .',
		'id' => 'youtube_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Vimeo URL',
		'desc' => 'Type the vimeo URL from here .',
		'id' => 'vimeo_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Skype',
		'desc' => 'Type the skype from here .',
		'id' => 'skype_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Flickr URL',
		'desc' => 'Type the flickr URL from here .',
		'id' => 'flickr_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Soundcloud URL',
		'desc' => 'Type the soundcloud URL from here .',
		'id' => 'soundcloud_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Instagram URL',
		'desc' => 'Type the instagram URL from here .',
		'id' => 'instagram_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Pinterest URL',
		'desc' => 'Type the pinterest URL from here .',
		'id' => 'pinterest_icon_h',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Breadcrumbs settings',
		'desc' => 'Select on to enable the breadcrumbs .',
		'id' => 'breadcrumbs',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Home page',
		'type' => 'heading');
	
	$options[] = array(
		'name' => "Head slide",
		'desc' => "Select the Head slide .",
		'id' => "head_slide",
		'std' => "none",
		'type' => "select",
		'options' => array(
			'header' => 'Header',
			'footer' => 'Footer',
			'none' => 'None',
		)
	);
	
	$options[] = array(
		'name' => 'Head top work in all pages or home page only ?',
		'desc' => 'Head top work in all pages or home page only ?',
		'id' => 'head_top_work',
		'std' => "home_page",
		'options' => array(
			'home_page' => 'Home page',
			'all_pages' => 'All pages',
		),
		'type' => 'select'
	);
	
	$options[] = array(
		'name' => "Head slide background",
		'desc' => "Select the head slide background .",
		'id' => "head_slide_background",
		'std' => "transparent",
		'type' => "select",
		'options' => array(
			'transparent' => 'Transparent',
			'blue' => 'Dark blue',
			'custom' => 'Custom',
		)
	);
	
	$options[] = array(
		'name' =>  "Custom Background",
		'desc' => "Custom Background",
		'id' => 'head_slide_custom_background',
		'std' => $background_defaults,
		'type' => 'background' );
		
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'head_slide_full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'News ticker enable or disable',
		'desc' => 'News ticker enable or disable .',
		'id' => 'news_ticker',
		'std' => "on",
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "News ticker excerpt title",
		'desc' => "put the news ticker excerpt title",
		'id' => 'news_excerpt_title',
		'type' => 'text',
		'std' => "5");
	
	$options[] = array(
		'name' => "News ticker number",
		'desc' => "put the news ticker number",
		'id' => 'news_number',
		'type' => 'text',
		'std' => "5");
	
	$options[] = array(
		'name' => "Order by",
		'desc' => "Select the news ticker order by .",
		'id' => "orderby_news",
		'std' => "recent",
		'type' => "select",
		'options' => array(
			'recent' => 'Recent',
			'popular' => 'Popular',
			'random' => 'Random',
		)
	);
	
	$options[] = array(
		'name'		=> "Display by",
		'id'		=> "news_display",
		'type'		=> 'select',
		'options'	=> array(
			'lasts'	=> 'Lasts',
			'single_category' => 'Single category',
			'multiple_categories' => 'Multiple categories',
			'posts'	=> 'Custom posts',
		),
		'std'		=> 'lasts',
	);
	
	$options[] = array(
		'name'		=> 'Single category',
		'id'		=> 'news_single_category',
		'type'		=> 'select',
		'options'	=> $options_categories,
	);
	
	$options[] = array(
		'name' => "News ticker categories",
		'desc' => "Select the news ticker categories .",
		'id' => "news_categories",
		'std' => '',
		'options' => $options_categories,
		'type' => 'multicheck');
	
	$options[] = array(
		'name' => "Head posts",
		'desc' => "Select the head posts .",
		'id' => "news_posts",
		'std' => '',
		'options' => $options_posts,
		'type' => 'select',
		'multiple' => 'multiple');
	
	$options[] = array(
		'name' => 'Head slide setting',
		'class' => 'top_head_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' => "Head slide style",
		'desc' => "Select the head slide style .",
		'id' => "head_slide_style",
		'std' => "slideshow_thumbnail",
		'type' => "select",
		'options' => array(
			'slideshow' => 'Slideshow',
			'slideshow_thumbnail' => 'Slideshow and thumbnail',
			'thumbnail_slideshow' => 'Thumbnail and slideshow',
			'thumbnail' => 'Thumbnail',
			'video_container' => 'Video container',
			'video_full' => 'Video full width',
			'none' => 'None',
		)
	);
	
	$options[] = array(
		'name'		=> 'Video type',
		'id'		=> 'video_head',
		'type'		=> 'select',
		'options'	=> array(
			'youtube' => "Youtube",
			'vimeo' => "Vimeo",
			'daily' => "Dialymotion",
			'embed' => "Custom embed",
		),
		'std'		=> 'youtube',
		'desc'		=> 'Choose from here the video type'
	);
	
	$options[] = array(
		'name'		=> 'Custom embed',
		'desc'		=> "Put your Custom embed html",
		'id'		=> "custom_embed_head",
		'type'		=> 'textarea',
		'cols'		=> "40",
		'rows'		=> "8"
	);
	
	$options[] = array(
		'name'		=> 'Video ID',
		'id'		=> 'video_id_head',
		'desc'		=> 'Put here the video id : http://www.youtube.com/watch?v=sdUUx5FdySs EX : "sdUUx5FdySs"',
		'type'		=> 'text',
		'std'		=> ''
	);
	
	$options[] = array(
		'name' => "Slideshow overlay",
		'desc' => "Select the slideshow overlay .",
		'id' => "slide_overlay",
		'std' => "enable",
		'type' => "select",
		'options' => array(
			'enable' => 'Enable',
			'title' => 'Title',
			'disable' => 'Disable',
		)
	);
	
	$options[] = array(
		'name' => "Excerpt title for the slideshow",
		'desc' => "put the excerpt title for the slideshow",
		'id' => 'excerpt_title_slideshow',
		'type' => 'text',
		'std' => "5");
	
	$options[] = array(
		'name' => "Excerpt for the slideshow",
		'desc' => "put the excerpt for the slideshow",
		'id' => 'excerpt_slideshow',
		'type' => 'text',
		'std' => "25");
	
	$options[] = array(
		'name' => "Slides number",
		'desc' => "put the slides number",
		'id' => 'slideshow_number',
		'type' => 'text',
		'std' => "5");
	
	$options[] = array(
		'name' => "Order by",
		'desc' => "Select the slideshow order by .",
		'id' => "orderby_slide",
		'std' => "recent",
		'type' => "select",
		'options' => array(
			'recent' => 'Recent',
			'popular' => 'Popular',
			'random' => 'Random',
		)
	);
	
	$options[] = array(
		'name'		=> "Display by",
		'id'		=> "slideshow_display",
		'type'		=> 'select',
		'options'	=> array(
			'lasts'	=> 'Lasts',
			'single_category' => 'Single category',
			'multiple_categories' => 'Multiple categories',
			'posts'	=> 'Custom posts',
		),
		'std'		=> 'lasts',
	);
	
	$options[] = array(
		'name'		=> 'Single category',
		'id'		=> 'slideshow_single_category',
		'type'		=> 'select',
		'options'	=> $options_categories,
	);
	
	$options[] = array(
		'name' => "Slideshow categories",
		'desc' => "Select the slideshow categories .",
		'id' => "slideshow_categories",
		'std' => '',
		'options' => $options_categories,
		'type' => 'multicheck');
	
	$options[] = array(
		'name' => "Slideshow posts",
		'desc' => "Select the slideshow posts .",
		'id' => "slideshow_posts",
		'std' => '',
		'options' => $options_posts,
		'type' => 'select',
		'multiple' => 'multiple');
	
	$options[] = array(
		'name' => 'Thumbnail setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' => "Excerpt title for the thumbnail",
		'desc' => "put the excerpt title for the thumbnail",
		'id' => 'excerpt_title_thumbnail',
		'type' => 'text',
		'std' => "5");
	
	$options[] = array(
		'name' => "Thumbnail number",
		'desc' => "put the thumbnail number",
		'id' => 'thumbnail_number',
		'type' => 'text',
		'std' => "6");
	
	$options[] = array(
		'name' => "Order by",
		'desc' => "Select the thumbnail order by .",
		'id' => "orderby_thumbnail",
		'std' => "recent",
		'type' => "select",
		'options' => array(
			'recent' => 'Recent',
			'popular' => 'Popular',
			'random' => 'Random',
		)
	);
	
	$options[] = array(
		'name'		=> "Display by",
		'id'		=> "thumbnail_display",
		'type'		=> 'select',
		'options'	=> array(
			'lasts'	=> 'Lasts',
			'single_category' => 'Single category',
			'multiple_categories' => 'Multiple categories',
			'posts'	=> 'Custom posts',
		),
		'std'		=> 'lasts',
	);
	
	$options[] = array(
		'name'		=> 'Single category',
		'id'		=> 'thumbnail_single_category',
		'type'		=> 'select',
		'options'	=> $options_categories,
	);
	
	$options[] = array(
		'name' => "Thumbnail categories",
		'desc' => "Select the thumbnail categories .",
		'id' => "thumbnail_categories",
		'std' => '',
		'options' => $options_categories,
		'type' => 'multicheck');
	
	$options[] = array(
		'name' => "Thumbnail posts",
		'desc' => "Select the thumbnail posts .",
		'id' => "thumbnail_posts",
		'std' => '',
		'options' => $options_posts,
		'type' => 'select',
		'multiple' => 'multiple');
	
	$options[] = array(
		'name' => 'Captcha setting',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Captcha enable or disable in add post form',
		'desc' => 'Captcha enable or disable in add post form .',
		'id' => 'the_captcha',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Captcha enable or disable in register form',
		'desc' => 'Captcha enable or disable in register form .',
		'id' => 'the_captcha_register',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Captcha enable or disable in comment form',
		'desc' => 'Captcha enable or disable in comment form .',
		'id' => 'the_captcha_comment',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "Captcha style",
		'desc' => "Choose the captcha style",
		'id' => 'captcha_style',
		'std' => 'question_answer',
		'type' => 'radio',
		'options' => 
			array(
				"question_answer" => "Question and answer",
				"normal_captcha" => "Normal captcha"
		)
	);
	
	$options[] = array(
		'name' => 'Captcha answer enable or disable in forms',
		'desc' => 'Captcha answer enable or disable in forms .',
		'id' => 'show_captcha_answer',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "Captcha question",
		'desc' => "put the Captcha question",
		'id' => 'captcha_question',
		'type' => 'text',
		'std' => "What is the capital of Egypt ?");
	
	$options[] = array(
		'name' => "Captcha answer",
		'desc' => "put the Captcha answer",
		'id' => 'captcha_answer',
		'type' => 'text',
		'std' => "Cairo");
	
	$options[] = array(
		'name' => 'New post setting',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Any one can add post without register',
		'desc' => 'Any one can add post without register enable or disable .',
		'id' => 'add_post_no_register',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Choose post status',
		'desc' => 'Choose post status after user publish the post .',
		'id' => 'post_publish',
		'options' => array("publish" => "Publish","draft" => "Draft"),
		'std' => 'draft',
		'type' => 'select');
	
	$options[] = array(
		'name' => 'Tags enable or disable in add post form',
		'desc' => 'Select on to enable the tags in add post form .',
		'id' => 'tags_post',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Attachment in add post form',
		'desc' => 'Select on to enable the attachment in add post form .',
		'id' => 'attachment_post',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Details in add post form is required',
		'desc' => 'Details in add post form is required .',
		'id' => 'content_post',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'The users can edit the posts ?',
		'desc' => 'The users can edit the posts ?',
		'id' => 'can_edit_post',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "Edit post page",
		'desc' => "Create a page using the Edit post template and select it here",
		'id' => 'edit_post',
		'type' => 'select',
		'options' => $options_pages);
	
	$options[] = array(
		'name' => 'Active user can delete the posts',
		'desc' => 'Select on if you want the user can delete the posts .',
		'id' => 'post_delete',
		'std' => 0,
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Blog & Article settings',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Post style',
		'desc' => 'Choose post style from here .',
		'id' => 'post_style',
		'options' => array(
			'style_1'         => '1 column',
			'style_2'         => '2 columns',
			'style_3'         => '3 columns ( work in full with only )',
			'style_4'         => '1 columns small image',
			'style_5'         => '1 columns large image',
			'style_6'         => 'Style 6',
			'style_7'         => 'Style 7',
		),
		'std' => 'style_1',
		'type' => 'radio');
	
	$options[] = array(
		'name' => 'Type the data format see this link also : http://codex.wordpress.org/Formatting_Date_and_Time',
		'desc' => 'Type here your data format .',
		'id' => 'date_format',
		'std' => 'F j, Y',
		'type' => 'text');
	
	$options[] = array(
		'desc' => "Sort your sections .",
		'name' => "Sort your sections .",
		'id' => "order_sections_li",
		'std' => '',
		'type' => 'sections');
	
	$options[] = array(
		'name' => "Note : About the author don't work in single portfolio page.",
		'class' => 'home_page_display',
		'type' => 'info');
	
	$options[] = array(
		'name' => 'Category description enable or disable',
		'desc' => 'Click on to enable the category description in the category page .',
		'id' => 'category_description',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Category rss enable or disable',
		'desc' => 'Click on to enable the category rss in the category page .',
		'id' => 'category_rss',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Hide the featured image in the single post',
		'desc' => 'Click on to hide the featured image in the single post .',
		'id' => 'featured_image',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Author by enable or disable',
		'desc' => 'Author by enable or disable .',
		'id' => 'author_by',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Category post enable or disable',
		'desc' => 'Category post enable or disable .',
		'id' => 'category_post',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Post meta enable or disable',
		'desc' => 'Post meta enable or disable .',
		'id' => 'post_meta',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Review enable or disable',
		'desc' => 'Review enable or disable .',
		'id' => 'post_review',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Post type enable or disable',
		'desc' => 'Post type enable or disable .',
		'id' => 'post_type',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Post author enable or disable',
		'desc' => 'Post author enable or disable .',
		'id' => 'post_author',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Share enable or disable',
		'desc' => 'Share enable or disable .',
		'id' => 'post_share',
		'std' => 'on',
		'type' => 'checkbox');
		
	$options[] = array(
		'name' => 'Views enable or disable',
		'desc' => 'Views enable or disable .',
		'id' => 'post_views',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Excerpt type ',
		'desc' => 'Choose form here the excerpt type .',
		'id' => 'excerpt_type',
		'std' => 5,
		'type' => "select",
		'options' => array(
			'words' => 'Words',
			'characters' => 'Characters')
		);
	
	$options[] = array(
		'name' => 'Excerpt title ( Work in style 6 )',
		'desc' => 'Put here the excerpt title .',
		'id' => 'post_excerpt_title',
		'std' => 5,
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Excerpt post',
		'desc' => 'Put here the excerpt post .',
		'id' => 'post_excerpt',
		'std' => 40,
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Pagination style',
		'desc' => 'Choose pagination style from here .',
		'id' => 'post_pagination',
		'options' => array(
			'standard' => 'Standard',
			'pagination' => 'Pagination',
		),
		'std' => 'standard',
		'type' => 'radio');
	
	$options[] = array(
		'name' => 'Navigation post enable or disable',
		'desc' => 'Navigation post ( next and previous posts) enable or disable .',
		'id' => 'post_navigation',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Author info box enable or disable',
		'desc' => 'Author info box enable or disable .',
		'id' => 'post_author_box',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Related post enable or disable',
		'desc' => 'Related post enable or disable .',
		'id' => 'related_post',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Related post number',
		'desc' => 'Type related post number from here .',
		'id' => 'related_number',
		'std' => '4',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Related post number full width',
		'desc' => 'Type related post number full width from here .',
		'id' => 'related_number_full',
		'std' => '6',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Excerpt title in related post',
		'desc' => 'Type excerpt title in related post from here .',
		'id' => 'excerpt_related_title',
		'std' => '5',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Comments enable or disable',
		'desc' => 'Comments enable or disable .',
		'id' => 'post_comments',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Content in 404 page',
		'desc' => 'Type here the content in 404 page .',
		'id' => '404_page',
		'std' => 'Lorem ipsum dolor sit amet, mauris suspendisse viverra eleifend tortor tellus suscipit, tortor aliquet at nulla mus, dignissim neque, nulla neque.',
		'type' => 'textarea');
	
	if ( class_exists( 'woocommerce' ) ) {
		$options[] = array(
			'name' => 'Products Setting',
			'type' => 'heading');
		
		$options[] = array(
			'name' => 'Related products number',
			'desc' => 'Type related products number from here .',
			'id' => 'related_products_number',
			'std' => '3',
			'type' => 'text');
		
		$options[] = array(
			'name' => 'Related products number full width',
			'desc' => 'Type related products number full width from here .',
			'id' => 'related_products_number_full',
			'std' => '4',
			'type' => 'text');
		
		$options[] = array(
			'name' => 'Excerpt title in products pages',
			'desc' => 'Type excerpt title in products pages from here .',
			'id' => 'products_excerpt_title',
			'std' => '40',
			'type' => 'text');
		
		$options[] = array(
			'name' => "Products sidebar layout",
			'desc' => "Products sidebar layout .",
			'id' => "products_sidebar_layout",
			'std' => "default",
			'type' => "images",
			'options' => array(
				'default' => $imagepath.'sidebar_default.jpg',
				'right' => $imagepath.'sidebar_right.jpg',
				'full' => $imagepath.'sidebar_no.jpg',
				'left' => $imagepath.'sidebar_left.jpg',
				'centered' => $imagepath.'centered.jpg',
			)
		);
		
		$options[] = array(
			'name' => "Products Page Sidebar",
			'desc' => "Products Page Sidebar .",
			'id' => "products_sidebar",
			'std' => '',
			'options' => $new_sidebars,
			'type' => 'select');
		
		$options[] = array(
			'name' => "Products page layout",
			'desc' => "Products page layout .",
			'id' => "products_layout",
			'std' => "default",
			'type' => "images",
			'options' => array(
				'default' => $imagepath.'sidebar_default.jpg',
				'full' => $imagepath.'full.jpg',
				'fixed' => $imagepath.'fixed.jpg',
				'fixed_2' => $imagepath.'fixed_2.jpg'
			)
		);
		
		$options[] = array(
			'name' => "Choose template",
			'desc' => "Choose template layout .",
			'id' => "products_template",
			'std' => "default",
			'type' => "images",
			'options' => array(
				'default' => $imagepath.'sidebar_default.jpg',
				'grid_1200' => $imagepath.'template_1200.jpg',
				'grid_970' => $imagepath.'template_970.jpg'
			)
		);
		
		$options[] = array(
			'name' => "Site skin",
			'desc' => "Choose Site skin .",
			'id' => "products_skin_l",
			'std' => "default",
			'type' => "images",
			'options' => array(
				'default' => $imagepath.'sidebar_default.jpg',
				'site_light' => $imagepath.'light.jpg',
				'site_dark' => $imagepath.'dark.jpg'
			)
		);
		
		$options[] = array(
			'name' => "Choose Your Skin",
			'desc' => "Choose Your Skin",
			'class' => "site_skin",
			'id' => "products_skin",
			'std' => "default",
			'type' => "images",
			'options' => array(
				'default'	=> $imagepath.'default_color.jpg',
				'skin'	=> $imagepath.'default.jpg',
				'bright_cyan'	=> $imagepath.'bright_cyan.jpg',
				'bright_pink'	=> $imagepath.'bright_pink.jpg',
				'dark_grayish_blue'	=> $imagepath.'dark_grayish_blue.jpg',
				'dark_grayish_cyan'	=> $imagepath.'dark_grayish_cyan.jpg',
				'dark_grayish_cyan_2'	=> $imagepath.'dark_grayish_cyan_2.jpg',
				'dark_green'	=> $imagepath.'dark_green.jpg',
				'dark_moderate_violet'	=> $imagepath.'dark_moderate_violet.jpg',
				'dark_pink'	=> $imagepath.'dark_pink.jpg',
				'light_orange'	=> $imagepath.'light_orange.jpg',
				'lime_green'	=> $imagepath.'lime_green.jpg',
				'moderate_blue'	=> $imagepath.'moderate_blue.jpg',
				'moderate_blue_2'	=> $imagepath.'moderate_blue_2.jpg',
				'moderate_cyan'	=> $imagepath.'moderate_cyan.jpg',
				'moderate_violet'	=> $imagepath.'moderate_violet.jpg',
				'slightly_desaturated_blue'	=> $imagepath.'slightly_desaturated_blue.jpg',
				'soft_blue'	=> $imagepath.'soft_blue.jpg',
				'soft_cyan'	=> $imagepath.'soft_cyan.jpg',
				'soft_red'	=> $imagepath.'soft_red.jpg',
				'soft_yellow'	=> $imagepath.'soft_yellow.jpg',
				'strong_cyan'	=> $imagepath.'strong_cyan.jpg',
				'strong_orange'	=> $imagepath.'strong_orange.jpg',
				'strong_red'	=> $imagepath.'strong_red.jpg',
				'very_light_pink'	=> $imagepath.'very_light_pink.jpg',
				'vivid_cyan'	=> $imagepath.'vivid_cyan.jpg',
				'vivid_orange'	=> $imagepath.'vivid_orange.jpg',
				'vivid_orange_2'	=> $imagepath.'vivid_orange_2.jpg',
				'vivid_orange_3'	=> $imagepath.'vivid_orange_3.jpg',
				'vivid_yellow'	=> $imagepath.'vivid_yellow.jpg',
				'vivid_yellow_2'	=> $imagepath.'vivid_yellow_2.jpg',
				'yellow'	=> $imagepath.'yellow.jpg',
				'red'	=> $imagepath.'red.jpg',
				'purple'	=> $imagepath.'purple.jpg',
				'orange'	=> $imagepath.'orange.jpg',
				'light_red'	=> $imagepath.'light_red.jpg',
				'green'	=> $imagepath.'green.jpg',
				'gray'	=> $imagepath.'gray.jpg',
				'blue'	=> $imagepath.'blue.jpg',
			)
		);
		
		$options[] = array(
			'name' => "Primary Color",
			'desc' => "Primary Color",
			'id' => 'products_primary_color',
			'type' => 'color' );
		
		$options[] = array(
			'name' => "Secondary Color ( it's darkness more than primary color )",
			'desc' => "Secondary Color ( it's darkness more than primary color )",
			'id' => 'products_secondary_color',
			'type' => 'color' );
		
		$options[] = array(
			'name' => "Background Type",
			'desc' => "Background Type",
			'id' => 'products_background_type',
			'std' => 'patterns',
			'type' => 'radio',
			'options' => 
				array(
					"patterns" => "Patterns",
					"custom_background" => "Custom Background"
				)
		);
	
		$options[] = array(
			'name' => "Background Color",
			'desc' => "Background Color",
			'id' => 'products_background_color',
			'std' => "#FFF",
			'type' => 'color' );
			
		$options[] = array(
			'name' => "Choose Pattern",
			'desc' => "Choose Pattern",
			'id' => "products_background_pattern",
			'std' => "bg13",
			'type' => "images",
			'options' => array(
				'bg1' => $imagepath.'bg1.jpg',
				'bg2' => $imagepath.'bg2.jpg',
				'bg3' => $imagepath.'bg3.jpg',
				'bg4' => $imagepath.'bg4.jpg',
				'bg5' => $imagepath.'bg5.jpg',
				'bg6' => $imagepath.'bg6.jpg',
				'bg7' => $imagepath.'bg7.jpg',
				'bg8' => $imagepath.'bg8.jpg',
				'bg9' => $imagepath.'../../images/patterns/bg9.png',
				'bg10' => $imagepath.'../../images/patterns/bg10.png',
				'bg11' => $imagepath.'../../images/patterns/bg11.png',
				'bg12' => $imagepath.'../../images/patterns/bg12.png',
				'bg13' => $imagepath.'bg13.jpg',
				'bg14' => $imagepath.'bg14.jpg',
				'bg15' => $imagepath.'../../images/patterns/bg15.png',
				'bg16' => $imagepath.'../../images/patterns/bg16.png',
				'bg17' => $imagepath.'bg17.jpg',
				'bg18' => $imagepath.'bg18.jpg',
				'bg19' => $imagepath.'bg19.jpg',
				'bg20' => $imagepath.'bg20.jpg',
				'bg21' => $imagepath.'../../images/patterns/bg21.png',
				'bg22' => $imagepath.'bg22.jpg',
				'bg23' => $imagepath.'../../images/patterns/bg23.png',
				'bg24' => $imagepath.'../../images/patterns/bg24.png',
		));
	
		$options[] = array(
			'name' =>  "Custom Background",
			'desc' => "Custom Background",
			'id' => 'products_custom_background',
			'std' => $background_defaults,
			'type' => 'background' );
			
		$options[] = array(
			'name' => "Full Screen Background",
			'desc' => "Click on to Full Screen Background",
			'id' => 'products_full_screen_background',
			'std' => '0',
			'type' => 'checkbox');
	}
	
	$options[] = array(
		'name' => 'Sidebar',
		'type' => 'heading');
	
	$options[] = array(
		'desc' => "Add your sidebars .",
		'id' => "sidebars",
		'std' => '',
		'type' => 'sidebar');
	
	$options[] = array(
		'name' => "Sidebar layout",
		'desc' => "Sidebar layout .",
		'id' => "sidebar_layout",
		'std' => "right",
		'type' => "images",
		'options' => array(
			'right' => $imagepath.'sidebar_right.jpg',
			'full' => $imagepath.'sidebar_no.jpg',
			'left' => $imagepath.'sidebar_left.jpg',
			'centered' => $imagepath.'centered.jpg',
		)
	);
	
	$options[] = array(
		'name' => "Sticky sidebar",
		'desc' => "Click on to active the sticky sidebar",
		'id' => 'sticky_sidebar',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => "Home Page Sidebar",
		'desc' => "Home Page Sidebar .",
		'id' => "sidebar_home",
		'std' => '',
		'options' => $new_sidebars,
		'type' => 'select');
	
	$options[] = array(
		'name' => "Else home page , single and page",
		'desc' => "Else home page , single and page .",
		'id' => "else_sidebar",
		'std' => '',
		'options' => $new_sidebars,
		'type' => 'select');
	
	$options[] = array(
		'name' => 'Author Styling',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Post author enable or disable in about author box',
		'desc' => 'Post author enable or disable in about author box .',
		'id' => 'author_img',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Post style',
		'desc' => 'Choose post style from here .',
		'id' => 'author_post_style',
		'options' => array(
			'style_1' => '1 column',
			'style_2' => '2 columns',
			'style_3' => '3 columns ( work in full with only )',
			'style_4' => '1 columns small image',
			'style_5' => '1 columns large image',
			'style_6' => 'Style 6',
			'style_7' => 'Style 7',
			'slider'  => 'Slider',
		),
		'std' => 'style_1',
		'type' => 'radio');
	
	$options[] = array(
		'name' => 'Blog pages show at most ( work in slider style only )',
		'desc' => 'Type here blog pages show at most ( work in slider style only )',
		'id' => 'author_blog_pages_show',
		'std' => '4',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Excerpt title in author page',
		'desc' => 'Type excerpt title in author page from here .',
		'id' => 'author_excerpt_title',
		'std' => '5',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Author sidebar layout",
		'desc' => "Author sidebar layout .",
		'id' => "author_sidebar_layout",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default' => $imagepath.'sidebar_default.jpg',
			'right' => $imagepath.'sidebar_right.jpg',
			'full' => $imagepath.'sidebar_no.jpg',
			'left' => $imagepath.'sidebar_left.jpg',
			'centered' => $imagepath.'centered.jpg',
		)
	);
	
	$options[] = array(
		'name' => "Author Page Sidebar",
		'desc' => "Author Page Sidebar .",
		'id' => "author_sidebar",
		'std' => '',
		'options' => $new_sidebars,
		'type' => 'select');
	
	$options[] = array(
		'name' => "Author page layout",
		'desc' => "Author page layout .",
		'id' => "author_layout",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default' => $imagepath.'sidebar_default.jpg',
			'full' => $imagepath.'full.jpg',
			'fixed' => $imagepath.'fixed.jpg',
			'fixed_2' => $imagepath.'fixed_2.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Choose template",
		'desc' => "Choose template layout .",
		'id' => "author_template",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default' => $imagepath.'sidebar_default.jpg',
			'grid_1200' => $imagepath.'template_1200.jpg',
			'grid_970' => $imagepath.'template_970.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Site skin",
		'desc' => "Choose Site skin .",
		'id' => "author_skin_l",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default' => $imagepath.'sidebar_default.jpg',
			'site_light' => $imagepath.'light.jpg',
			'site_dark' => $imagepath.'dark.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Choose Your Skin",
		'desc' => "Choose Your Skin",
		'class' => "site_skin",
		'id' => "author_skin",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default'	=> $imagepath.'default_color.jpg',
			'skin'	=> $imagepath.'default.jpg',
			'bright_cyan'	=> $imagepath.'bright_cyan.jpg',
			'bright_pink'	=> $imagepath.'bright_pink.jpg',
			'dark_grayish_blue'	=> $imagepath.'dark_grayish_blue.jpg',
			'dark_grayish_cyan'	=> $imagepath.'dark_grayish_cyan.jpg',
			'dark_grayish_cyan_2'	=> $imagepath.'dark_grayish_cyan_2.jpg',
			'dark_green'	=> $imagepath.'dark_green.jpg',
			'dark_moderate_violet'	=> $imagepath.'dark_moderate_violet.jpg',
			'dark_pink'	=> $imagepath.'dark_pink.jpg',
			'light_orange'	=> $imagepath.'light_orange.jpg',
			'lime_green'	=> $imagepath.'lime_green.jpg',
			'moderate_blue'	=> $imagepath.'moderate_blue.jpg',
			'moderate_blue_2'	=> $imagepath.'moderate_blue_2.jpg',
			'moderate_cyan'	=> $imagepath.'moderate_cyan.jpg',
			'moderate_violet'	=> $imagepath.'moderate_violet.jpg',
			'slightly_desaturated_blue'	=> $imagepath.'slightly_desaturated_blue.jpg',
			'soft_blue'	=> $imagepath.'soft_blue.jpg',
			'soft_cyan'	=> $imagepath.'soft_cyan.jpg',
			'soft_red'	=> $imagepath.'soft_red.jpg',
			'soft_yellow'	=> $imagepath.'soft_yellow.jpg',
			'strong_cyan'	=> $imagepath.'strong_cyan.jpg',
			'strong_orange'	=> $imagepath.'strong_orange.jpg',
			'strong_red'	=> $imagepath.'strong_red.jpg',
			'very_light_pink'	=> $imagepath.'very_light_pink.jpg',
			'vivid_cyan'	=> $imagepath.'vivid_cyan.jpg',
			'vivid_orange'	=> $imagepath.'vivid_orange.jpg',
			'vivid_orange_2'	=> $imagepath.'vivid_orange_2.jpg',
			'vivid_orange_3'	=> $imagepath.'vivid_orange_3.jpg',
			'vivid_yellow'	=> $imagepath.'vivid_yellow.jpg',
			'vivid_yellow_2'	=> $imagepath.'vivid_yellow_2.jpg',
			'yellow'	=> $imagepath.'yellow.jpg',
			'red'	=> $imagepath.'red.jpg',
			'purple'	=> $imagepath.'purple.jpg',
			'orange'	=> $imagepath.'orange.jpg',
			'light_red'	=> $imagepath.'light_red.jpg',
			'green'	=> $imagepath.'green.jpg',
			'gray'	=> $imagepath.'gray.jpg',
			'blue'	=> $imagepath.'blue.jpg',
		)
	);
	
	$options[] = array(
		'name' => "Primary Color",
		'desc' => "Primary Color",
		'id' => 'author_primary_color',
		'type' => 'color' );
	
	$options[] = array(
		'name' => "Secondary Color ( it's darkness more than primary color )",
		'desc' => "Secondary Color ( it's darkness more than primary color )",
		'id' => 'author_secondary_color',
		'type' => 'color' );
	
	$options[] = array(
		'name' => "Background Type",
		'desc' => "Background Type",
		'id' => 'author_background_type',
		'std' => 'patterns',
		'type' => 'radio',
		'options' => 
			array(
				"patterns" => "Patterns",
				"custom_background" => "Custom Background"
			)
	);

	$options[] = array(
		'name' => "Background Color",
		'desc' => "Background Color",
		'id' => 'author_background_color',
		'std' => "#FFF",
		'type' => 'color' );
		
	$options[] = array(
		'name' => "Choose Pattern",
		'desc' => "Choose Pattern",
		'id' => "author_background_pattern",
		'std' => "bg13",
		'type' => "images",
		'options' => array(
			'bg1' => $imagepath.'bg1.jpg',
			'bg2' => $imagepath.'bg2.jpg',
			'bg3' => $imagepath.'bg3.jpg',
			'bg4' => $imagepath.'bg4.jpg',
			'bg5' => $imagepath.'bg5.jpg',
			'bg6' => $imagepath.'bg6.jpg',
			'bg7' => $imagepath.'bg7.jpg',
			'bg8' => $imagepath.'bg8.jpg',
			'bg9' => $imagepath.'../../images/patterns/bg9.png',
			'bg10' => $imagepath.'../../images/patterns/bg10.png',
			'bg11' => $imagepath.'../../images/patterns/bg11.png',
			'bg12' => $imagepath.'../../images/patterns/bg12.png',
			'bg13' => $imagepath.'bg13.jpg',
			'bg14' => $imagepath.'bg14.jpg',
			'bg15' => $imagepath.'../../images/patterns/bg15.png',
			'bg16' => $imagepath.'../../images/patterns/bg16.png',
			'bg17' => $imagepath.'bg17.jpg',
			'bg18' => $imagepath.'bg18.jpg',
			'bg19' => $imagepath.'bg19.jpg',
			'bg20' => $imagepath.'bg20.jpg',
			'bg21' => $imagepath.'../../images/patterns/bg21.png',
			'bg22' => $imagepath.'bg22.jpg',
			'bg23' => $imagepath.'../../images/patterns/bg23.png',
			'bg24' => $imagepath.'../../images/patterns/bg24.png',
	));

	$options[] = array(
		'name' =>  "Custom Background",
		'desc' => "Custom Background",
		'id' => 'author_custom_background',
		'std' => $background_defaults,
		'type' => 'background' );
		
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'author_full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Styling',
		'type' => 'heading');
	
	$options[] = array(
		'name' => "Home page layout",
		'desc' => "Home page layout .",
		'id' => "home_layout",
		'std' => "full",
		'type' => "images",
		'options' => array(
			'full' => $imagepath.'full.jpg',
			'fixed' => $imagepath.'fixed.jpg',
			'fixed_2' => $imagepath.'fixed_2.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Choose template",
		'desc' => "Choose template layout .",
		'id' => "home_template",
		'std' => "grid_1200",
		'type' => "images",
		'options' => array(
			'grid_1200' => $imagepath.'template_1200.jpg',
			'grid_970' => $imagepath.'template_970.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Site skin",
		'desc' => "Choose Site skin .",
		'id' => "site_skin_l",
		'std' => "site_light",
		'type' => "images",
		'options' => array(
			'site_light' => $imagepath.'light.jpg',
			'site_dark' => $imagepath.'dark.jpg'
		)
	);
	
	$options[] = array(
		'name' => "Choose Your Skin",
		'desc' => "Choose Your Skin",
		'class' => "site_skin",
		'id' => "site_skin",
		'std' => "default",
		'type' => "images",
		'options' => array(
			'default'	=> $imagepath.'default.jpg',
			'bright_cyan'	=> $imagepath.'bright_cyan.jpg',
			'bright_pink'	=> $imagepath.'bright_pink.jpg',
			'dark_grayish_blue'	=> $imagepath.'dark_grayish_blue.jpg',
			'dark_grayish_cyan'	=> $imagepath.'dark_grayish_cyan.jpg',
			'dark_grayish_cyan_2'	=> $imagepath.'dark_grayish_cyan_2.jpg',
			'dark_green'	=> $imagepath.'dark_green.jpg',
			'dark_moderate_violet'	=> $imagepath.'dark_moderate_violet.jpg',
			'dark_pink'	=> $imagepath.'dark_pink.jpg',
			'light_orange'	=> $imagepath.'light_orange.jpg',
			'lime_green'	=> $imagepath.'lime_green.jpg',
			'moderate_blue'	=> $imagepath.'moderate_blue.jpg',
			'moderate_blue_2'	=> $imagepath.'moderate_blue_2.jpg',
			'moderate_cyan'	=> $imagepath.'moderate_cyan.jpg',
			'moderate_violet'	=> $imagepath.'moderate_violet.jpg',
			'slightly_desaturated_blue'	=> $imagepath.'slightly_desaturated_blue.jpg',
			'soft_blue'	=> $imagepath.'soft_blue.jpg',
			'soft_cyan'	=> $imagepath.'soft_cyan.jpg',
			'soft_red'	=> $imagepath.'soft_red.jpg',
			'soft_yellow'	=> $imagepath.'soft_yellow.jpg',
			'strong_cyan'	=> $imagepath.'strong_cyan.jpg',
			'strong_orange'	=> $imagepath.'strong_orange.jpg',
			'strong_red'	=> $imagepath.'strong_red.jpg',
			'very_light_pink'	=> $imagepath.'very_light_pink.jpg',
			'vivid_cyan'	=> $imagepath.'vivid_cyan.jpg',
			'vivid_orange'	=> $imagepath.'vivid_orange.jpg',
			'vivid_orange_2'	=> $imagepath.'vivid_orange_2.jpg',
			'vivid_orange_3'	=> $imagepath.'vivid_orange_3.jpg',
			'vivid_yellow'	=> $imagepath.'vivid_yellow.jpg',
			'vivid_yellow_2'	=> $imagepath.'vivid_yellow_2.jpg',
			'yellow'	=> $imagepath.'yellow.jpg',
			'red'	=> $imagepath.'red.jpg',
			'purple'	=> $imagepath.'purple.jpg',
			'orange'	=> $imagepath.'orange.jpg',
			'light_red'	=> $imagepath.'light_red.jpg',
			'green'	=> $imagepath.'green.jpg',
			'gray'	=> $imagepath.'gray.jpg',
			'blue'	=> $imagepath.'blue.jpg',
		)
	);
	
	$options[] = array(
		'name' => "Primary Color",
		'desc' => "Primary Color",
		'id' => 'primary_color',
		'type' => 'color' );
	
	$options[] = array(
		'name' => "Secondary Color ( it's darkness more than primary color )",
		'desc' => "Secondary Color ( it's darkness more than primary color )",
		'id' => 'secondary_color',
		'type' => 'color' );
	
	$options[] = array(
		'name' => "Background Type",
		'desc' => "Background Type",
		'id' => 'background_type',
		'std' => 'patterns',
		'type' => 'radio',
		'options' => 
			array(
				"patterns" => "Patterns",
				"custom_background" => "Custom Background"
			)
		);

	$options[] = array(
		'name' => "Background Color",
		'desc' => "Background Color",
		'id' => 'background_color',
		'std' => "#FFF",
		'type' => 'color' );
		
	$options[] = array(
		'name' => "Choose Pattern",
		'desc' => "Choose Pattern",
		'id' => "background_pattern",
		'std' => "bg13",
		'type' => "images",
		'options' => array(
			'bg1' => $imagepath.'bg1.jpg',
			'bg2' => $imagepath.'bg2.jpg',
			'bg3' => $imagepath.'bg3.jpg',
			'bg4' => $imagepath.'bg4.jpg',
			'bg5' => $imagepath.'bg5.jpg',
			'bg6' => $imagepath.'bg6.jpg',
			'bg7' => $imagepath.'bg7.jpg',
			'bg8' => $imagepath.'bg8.jpg',
			'bg9' => $imagepath.'../../images/patterns/bg9.png',
			'bg10' => $imagepath.'../../images/patterns/bg10.png',
			'bg11' => $imagepath.'../../images/patterns/bg11.png',
			'bg12' => $imagepath.'../../images/patterns/bg12.png',
			'bg13' => $imagepath.'bg13.jpg',
			'bg14' => $imagepath.'bg14.jpg',
			'bg15' => $imagepath.'../../images/patterns/bg15.png',
			'bg16' => $imagepath.'../../images/patterns/bg16.png',
			'bg17' => $imagepath.'bg17.jpg',
			'bg18' => $imagepath.'bg18.jpg',
			'bg19' => $imagepath.'bg19.jpg',
			'bg20' => $imagepath.'bg20.jpg',
			'bg21' => $imagepath.'../../images/patterns/bg21.png',
			'bg22' => $imagepath.'bg22.jpg',
			'bg23' => $imagepath.'../../images/patterns/bg23.png',
			'bg24' => $imagepath.'../../images/patterns/bg24.png',
	));

	$options[] = array(
		'name' =>  "Custom Background",
		'desc' => "Custom Background",
		'id' => 'custom_background',
		'std' => $background_defaults,
		'type' => 'background' );
		
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Typography',
		'type' => 'heading');
	
	$options[] = array(
		"name" => "Main font",
		"desc" => "Typography",
		"id" => "main_font",
		"type" => "typography",
		'options' => array('faces' => vpanel_google_fonts(),"color" => false,"styles" => false,"sizes" => false));
	
	$options[] = array(
		"name" => "Secondary font",
		"desc" => "Secondary font",
		"id" => "secondary_font",
		"type" => "typography",
		'options' => array('faces' => vpanel_google_fonts(),"color" => false,"styles" => false,"sizes" => false));
	
	$options[] = array(
		"name" => "Third font",
		"desc" => "Third font",
		"id" => "third_font",
		"type" => "typography",
		'options' => array('faces' => vpanel_google_fonts(),"color" => false,"styles" => false,"sizes" => false));
	
	$options[] = array(
		"name" => "General Typography",
		"desc" => "General Typography",
		"id" => "general_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "General link color",
		"desc" => "General link color",
		"id" => "general_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "H1",
		"desc" => "Typography",
		"id" => "h1",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		"name" => "H2",
		"desc" => "Typography",
		"id" => "h2",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		"name" => "H3",
		"desc" => "Typography",
		"id" => "h3",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		"name" => "H4",
		"desc" => "Typography",
		"id" => "h4",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		"name" => "H5",
		"desc" => "Typography",
		"id" => "h5",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		"name" => "H6",
		"desc" => "Typography",
		"id" => "h6",
		"type" => "typography",
		'options' => array('faces' => false,"color" => false));
	
	$options[] = array(
		'name' => 'Header setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' =>  "Header background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'header_image',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'header_full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		"name" => "Header link color",
		"desc" => "Header link color",
		"id" => "header_link_color",
		"type" => "color");
	
	/*
	$options[] = array(
		"name" => "Header link color hover",
		"desc" => "Header link color hover",
		"id" => "header_link_color_hover",
		"type" => "color");*/
	
	$options[] = array(
		"name" => "Nav menu",
		"desc" => "Nav menu",
		"id" => "nav_menu",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Nav menu hover",
		"desc" => "Nav menu hover",
		"id" => "nav_menu_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Nav drop menu",
		"desc" => "Nav menu",
		"id" => "nav_drop_menu",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Nav drop menu background",
		"desc" => "Nav drop menu background",
		"id" => "nav_drop_menu_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Nav drop menu border",
		"desc" => "Nav drop menu border",
		"id" => "nav_drop_menu_border",
		"type" => "color");
	
	$options[] = array(
		"name" => "Nav drop menu link hover",
		"desc" => "Nav drop menu link hover",
		"id" => "nav_drop_menu_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu background",
		"desc" => "Icon menu background",
		"id" => "icon_menu_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu border",
		"desc" => "Icon menu border",
		"id" => "icon_menu_border",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu link",
		"desc" => "Icon menu link",
		"id" => "icon_menu_link",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu background hover",
		"desc" => "Icon menu background hover",
		"id" => "icon_menu_background_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu border hover",
		"desc" => "Icon menu border hover",
		"id" => "icon_menu_border_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Icon menu link hover",
		"desc" => "Icon menu link hover",
		"id" => "icon_menu_link_hover",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Breadcrumbs setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		"name" => "Breadcrumbs typography",
		"desc" => "Breadcrumbs typography",
		"id" => "breadcrumbs_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Breadcrumbs link color",
		"desc" => "Breadcrumbs link color",
		"id" => "breadcrumbs_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Breadcrumbs link hover color",
		"desc" => "Breadcrumbs link hover color",
		"id" => "breadcrumbs_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		'name' => 'News setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' =>  "Head background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'head_background_color',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		"name" => "Head typography",
		"desc" => "Head typography",
		"id" => "head_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		'name' =>  "News background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'news_image',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		"name" => "News link typography",
		"desc" => "News link typography",
		"id" => "news_link_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "News link hover color",
		"desc" => "News link hover color",
		"id" => "news_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "News arrow background",
		"desc" => "News arrow background",
		"id" => "news_arrow_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "News arrow color",
		"desc" => "News arrow color",
		"id" => "news_arrow_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "News arrow background hover",
		"desc" => "News arrow background hover",
		"id" => "news_arrow_background_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "News arrow color hover",
		"desc" => "News arrow color hover",
		"id" => "news_arrow_color_hover",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Slideshow setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' =>  "Slideshow background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'slideshow_image',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		"name" => "Slideshow link typography",
		"desc" => "Slideshow link typography",
		"id" => "slideshow_link_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Slideshow link hover color",
		"desc" => "Slideshow link hover color",
		"id" => "slideshow_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow content typography",
		"desc" => "Slideshow content typography",
		"id" => "slideshow_content_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Slideshow meta border",
		"desc" => "Slideshow meta border",
		"id" => "slideshow_meta_border",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow meta color",
		"desc" => "Slideshow meta color",
		"id" => "slideshow_meta_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow meta link color",
		"desc" => "Slideshow meta link color",
		"id" => "slideshow_meta_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow meta link hover color",
		"desc" => "Slideshow meta link hover color",
		"id" => "slideshow_meta_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow arrow background",
		"desc" => "Slideshow arrow background",
		"id" => "slideshow_arrow_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow arrow color",
		"desc" => "Slideshow arrow color",
		"id" => "slideshow_arrow_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow arrow background hover",
		"desc" => "Slideshow arrow background hover",
		"id" => "slideshow_arrow_background_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Slideshow arrow color hover",
		"desc" => "Slideshow arrow color hover",
		"id" => "slideshow_arrow_color_hover",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Page builder setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		"name" => "Title box typography",
		"desc" => "Title box typography",
		"id" => "title_box_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Under title color",
		"desc" => "Under title color",
		"id" => "under_title_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Title box link color",
		"desc" => "Title box link color",
		"id" => "title_box_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Title box link hover color",
		"desc" => "Title box link hover color",
		"id" => "title_box_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Title inner link typography",
		"desc" => "Title inner link typography",
		"id" => "title_inner_link_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Title inner link hover color",
		"desc" => "Title inner link hover color",
		"id" => "title_inner_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Box meta color",
		"desc" => "Box meta color",
		"id" => "box_meta_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Box meta link color",
		"desc" => "Box meta link color",
		"id" => "box_meta_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Box meta link hover color",
		"desc" => "Box meta link hover color",
		"id" => "box_meta_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content inner typography",
		"desc" => "Content inner typography",
		"id" => "content_inner_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		'name' => 'Widget setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		"name" => "Widget title",
		"desc" => "Widget title",
		"id" => "widget_title",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Widget title icon background",
		"desc" => "Widget title icon background",
		"id" => "widget_title_icon_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget title icon color",
		"desc" => "Widget title icon color",
		"id" => "widget_title_icon_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget color",
		"desc" => "Widget color",
		"id" => "widget_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget link color",
		"desc" => "Widget link color",
		"id" => "widget_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget link hover color",
		"desc" => "Widget link hover color",
		"id" => "widget_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Content setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		"name" => "Content title",
		"desc" => "Content title",
		"id" => "content_title",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Content title icon background - work in style 2",
		"desc" => "Content title icon background - work in style 2",
		"id" => "content_title_icon_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content title icon color - work in style 2",
		"desc" => "Content title icon color - work in style 2",
		"id" => "content_title_icon_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content title link",
		"desc" => "Content title link",
		"id" => "content_title_link",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content title link hover",
		"desc" => "Content title link hover",
		"id" => "content_title_link_hover",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content title",
		"desc" => "Content title",
		"id" => "content_typography",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Content link",
		"desc" => "Content link",
		"id" => "content_link",
		"type" => "color");
	
	$options[] = array(
		"name" => "Content link hover",
		"desc" => "Content link hover",
		"id" => "content_link_hover",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Footer setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' =>  "Footer background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'footer_image',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'footer_full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		"name" => "Footer color",
		"desc" => "Footer color",
		"id" => "footer_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Footer link color",
		"desc" => "Footer link color",
		"id" => "footer_link_color",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Widget setting in footer',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		"name" => "Widget title",
		"desc" => "Widget title",
		"id" => "footer_widget_title",
		"type" => "typography",
		'options' => array('faces' => false));
	
	$options[] = array(
		"name" => "Widget title icon background/under title",
		"desc" => "Widget title icon background/under title",
		"id" => "footer_widget_title_icon_background",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget title icon color",
		"desc" => "Widget title icon color",
		"id" => "footer_widget_title_icon_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget color",
		"desc" => "Widget color",
		"id" => "footer_widget_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget link color",
		"desc" => "Widget link color",
		"id" => "footer_widget_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Widget link hover color",
		"desc" => "Widget link hover color",
		"id" => "footer_widget_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Footer bottom setting',
		'class' => 'top_head_setting thumbnail_setting',
		'type' => 'info');
	
	$options[] = array(
		'name' =>  "Footer bottom background",
		'desc' => "Upload a image, or enter URL to an image if it is already uploaded.",
		'id' => 'footer_bottom_image',
		'std' => $background_defaults,
		'type' => 'background' );
	
	$options[] = array(
		'name' => "Full Screen Background",
		'desc' => "Click on to Full Screen Background",
		'id' => 'footer_bottom_full_screen_background',
		'std' => '0',
		'type' => 'checkbox');
	
	$options[] = array(
		"name" => "Footer bottom color",
		"desc" => "Footer bottom color",
		"id" => "footer_bottom_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Footer bottom link color",
		"desc" => "Footer bottom link color",
		"id" => "footer_bottom_link_color",
		"type" => "color");
	
	$options[] = array(
		"name" => "Footer bottom link hover color",
		"desc" => "Footer bottom link hover color",
		"id" => "footer_bottom_link_hover_color",
		"type" => "color");
	
	$options[] = array(
		'name' => 'Advertising',
		'type' => 'heading');
	
	$options[] = array(
		'name' => "Advertising after header 1",
		'class' => 'home_page_display',
		'type' => 'info');
	
	$options[] = array(
		'name' => 'Advertising type',
		'desc' => 'Advertising type .',
		'id' => 'header_adv_type_1',
		'std' => 'custom_image',
		'type' => 'radio',
		'options' => array("display_code" => "Display code","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Image URL',
		'desc' => 'Upload a image, or enter URL to an image if it is already uploaded. ',
		'id' => 'header_adv_img_1',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Advertising url',
		'desc' => 'Advertising url. ',
		'id' => 'header_adv_href_1',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advertising Code html ( Ex: Google ads)",
		'desc' => "Advertising Code html ( Ex: Google ads)",
		'id' => 'header_adv_code_1',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => "Advertising after header 2",
		'class' => 'home_page_display',
		'type' => 'info');
	
	$options[] = array(
		'name' => 'Advertising type',
		'desc' => 'Advertising type .',
		'id' => 'header_adv_type',
		'std' => 'custom_image',
		'type' => 'radio',
		'options' => array("display_code" => "Display code","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Image URL',
		'desc' => 'Upload a image, or enter URL to an image if it is already uploaded. ',
		'id' => 'header_adv_img',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Advertising url',
		'desc' => 'Advertising url. ',
		'id' => 'header_adv_href',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advertising Code html ( Ex: Google ads)",
		'desc' => "Advertising Code html ( Ex: Google ads)",
		'id' => 'header_adv_code',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => "Advertising after share and tags ( in post )",
		'class' => 'home_page_display',
		'type' => 'info');
	
	$options[] = array(
		'name' => 'Advertising type',
		'desc' => 'Advertising type .',
		'id' => 'share_adv_type',
		'std' => 'custom_image',
		'type' => 'radio',
		'options' => array("display_code" => "Display code","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Image URL',
		'desc' => 'Upload a image, or enter URL to an image if it is already uploaded. ',
		'id' => 'share_adv_img',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Advertising url',
		'desc' => 'Advertising url. ',
		'id' => 'share_adv_href',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advertising Code html ( Ex: Google ads)",
		'desc' => "Advertising Code html ( Ex: Google ads)",
		'id' => 'share_adv_code',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => "Advertising after content",
		'class' => 'home_page_display',
		'type' => 'info');
	
	$options[] = array(
		'name' => 'Advertising type',
		'desc' => 'Advertising type .',
		'id' => 'content_adv_type',
		'std' => 'custom_image',
		'type' => 'radio',
		'options' => array("display_code" => "Display code","custom_image" => "Custom Image"));
	
	$options[] = array(
		'name' => 'Image URL',
		'desc' => 'Upload a image, or enter URL to an image if it is already uploaded. ',
		'id' => 'content_adv_img',
		'std' => '',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Advertising url',
		'desc' => 'Advertising url. ',
		'id' => 'content_adv_href',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advertising Code html ( Ex: Google ads)",
		'desc' => "Advertising Code html ( Ex: Google ads)",
		'id' => 'content_adv_code',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => 'Footer settings',
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Footer top enable or disable',
		'desc' => 'Footer top enable or disable .',
		'id' => 'footer_top',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Subscribe enable or disable',
		'desc' => 'Subscribe enable or disable .',
		'id' => 'subscribe_f',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Feedburner ID',
		'desc' => 'Type here the Feedburner ID .',
		'id' => 'feedburner_id',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'The title of subscribe',
		'desc' => 'Type here the title of subscribe .',
		'id' => 'feedburner_h3',
		'std' => 'Subscribe for our weekly news letter',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'The content of subscribe',
		'desc' => 'Type here the content of subscribe .',
		'id' => 'feedburner_p',
		'std' => 'Suspendisse non augue tincidunt, ullamcorper odio vel, tempor risus. In cursus lacus at mattis consectetur.',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Footer Layout ( level 1 )",
		'desc' => "Footer columns Layout ( level 1 ) .",
		'id' => "footer_layout_1",
		'std' => "footer_no",
		'type' => "images",
		'options' => array(
			'footer_1c' => $imagepath . 'footer_1c.jpg',
			'footer_2c' => $imagepath . 'footer_2c.jpg',
			'footer_3c' => $imagepath . 'footer_3c.jpg',
			'footer_4c' => $imagepath . 'footer_4c.jpg',
			'footer_no' => $imagepath . 'footer_no.jpg')
	);
	
	$options[] = array(
		'name' => "Footer Layout ( level 2 )",
		'desc' => "Footer columns Layout ( level 2 ) .",
		'id' => "footer_layout_2",
		'std' => "footer_no",
		'type' => "images",
		'options' => array(
			'footer_1c' => $imagepath . 'footer_1c.jpg',
			'footer_2c' => $imagepath . 'footer_2c.jpg',
			'footer_3c' => $imagepath . 'footer_3c.jpg',
			'footer_4c' => $imagepath . 'footer_4c.jpg',
			'footer_no' => $imagepath . 'footer_no.jpg')
	);
	
	$options[] = array(
		'name' => 'Copyrights',
		'desc' => 'Put the copyrights of footer .',
		'id' => 'footer_copyrights',
		'std' => 'Copyright 2014 Logger | Designed By <a href=http://7oroof.com/ target=_blank>7oroof</a> | Developed By <a href=http://2code.info/ target=_blank>2codeThemes</a>',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => 'Social enable or disable',
		'desc' => 'Social enable or disable .',
		'id' => 'social_icon_f',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'Facebook URL',
		'desc' => 'Type the facebook URL from here .',
		'id' => 'facebook_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter URL',
		'desc' => 'Type the twitter URL from here .',
		'id' => 'twitter_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Google plus URL',
		'desc' => 'Type the google plus URL from here .',
		'id' => 'gplus_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Linkedin URL',
		'desc' => 'Type the linkedin URL from here .',
		'id' => 'linkedin_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Dribbble URL',
		'desc' => 'Type the dribbble URL from here .',
		'id' => 'dribbble_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Youtube URL',
		'desc' => 'Type the youtube URL from here .',
		'id' => 'youtube_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Vimeo URL',
		'desc' => 'Type the vimeo URL from here .',
		'id' => 'vimeo_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Skype',
		'desc' => 'Type the skype from here .',
		'id' => 'skype_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Flickr URL',
		'desc' => 'Type the flickr URL from here .',
		'id' => 'flickr_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Soundcloud URL',
		'desc' => 'Type the soundcloud URL from here .',
		'id' => 'soundcloud_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Instagram URL',
		'desc' => 'Type the instagram URL from here .',
		'id' => 'instagram_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Pinterest URL',
		'desc' => 'Type the pinterest URL from here .',
		'id' => 'pinterest_icon_f',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Rss enable or disable',
		'desc' => 'Rss enable or disable .',
		'id' => 'rss_icon_f',
		'std' => 'on',
		'type' => 'checkbox');
	
	$options[] = array(
		'name' => 'RSS URL if you want change the default URL',
		'desc' => 'Type the RSS URL if you want change the default URL or leave it empty for enable the default URL .',
		'id' => 'rss_icon_f_other',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => "Advanced",
		'id' => "advanced",
		'type' => 'heading');
	
	$options[] = array(
		'name' => 'Google API ( Get it from here : https://developers.google.com/+/api/oauth )',
		'desc' => 'Type here the Google API. ',
		'id' => 'google_api',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter consumer key',
		'desc' => 'Twitter consumer key. ',
		'id' => 'twitter_consumer_key',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter consumer secret',
		'desc' => 'Twitter consumer secret. ',
		'id' => 'twitter_consumer_secret',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter access token',
		'desc' => 'Twitter access token. ',
		'id' => 'twitter_access_token',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => 'Twitter access token secret',
		'desc' => 'Twitter access token secret. ',
		'id' => 'twitter_access_token_secret',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => "If you wont to export setting please refresh the page before that",
		'type' => 'info');

	$options[] = array(
		'name' => "Export Setting",
		'desc' => "Copy this to saved file",
		'id' => 'export_setting',
		'export' => $current_options_e,
		'type' => 'export');

	$options[] = array(
		'name' => "Import Setting",
		'desc' => "Put here the import setting",
		'id' => 'import_setting',
		'type' => 'import');
	
	return $options;
}